/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.utils;

import com.xiaoyue.tinkers_ingenuity.utils.ItemUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class ToolUtils {
    @Nullable
    public static ToolStack checkTool(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            return ToolStack.from((ItemStack)stack);
        }
        return null;
    }

    @Nullable
    public static ToolStack getToolInHand(LivingEntity entity) {
        ItemStack stack;
        ItemStack offItem = entity.m_21206_();
        ItemStack mainItem = entity.m_21205_();
        Object object = mainItem.m_41619_() ? (offItem.m_41619_() ? null : offItem) : (stack = mainItem);
        if (stack != null) {
            return ToolUtils.checkTool(stack);
        }
        return null;
    }

    @Nullable
    public static ToolStack getHeldTool(LivingEntity entity, EquipmentSlot slot) {
        return Modifier.getHeldTool((LivingEntity)entity, (EquipmentSlot)slot);
    }

    public static boolean hasModifierInHeldTool(LivingEntity entity, Modifier modifier) {
        ToolStack tool = ToolUtils.getToolInHand(entity);
        if (ToolUtils.isNotBrokenOrNull((IToolStackView)tool)) {
            return tool.getModifierLevel(modifier) != 0;
        }
        return false;
    }

    public static int getModifierInHeldTool(LivingEntity entity, Modifier modifier) {
        ToolStack tool = ToolUtils.getToolInHand(entity);
        if (ToolUtils.isNotBrokenOrNull((IToolStackView)tool)) {
            return tool.getModifierLevel(modifier);
        }
        return 0;
    }

    @Nullable
    public static ToolStack getNotBrokenAndCooldownArmor(LivingEntity entity) {
        for (ItemStack stack : entity.m_6168_()) {
            ToolStack tool = ToolUtils.checkTool(stack);
            if (!ToolUtils.isNotBrokenOrNull((IToolStackView)tool) || !ItemUtils.noCooldown(entity, tool)) continue;
            return tool;
        }
        return null;
    }

    @Nullable
    public static ToolStack getNotBrokenArmor(LivingEntity entity) {
        for (ItemStack stack : entity.m_6168_()) {
            ToolStack tool = ToolUtils.checkTool(stack);
            if (!ToolUtils.isNotBrokenOrNull((IToolStackView)tool)) continue;
            return tool;
        }
        return null;
    }

    @Nullable
    public static ToolStack getNotBrokenToolInHand(LivingEntity entity) {
        if (ToolUtils.getHeldTool(entity, EquipmentSlot.OFFHAND) != null) {
            return ToolUtils.getHeldTool(entity, EquipmentSlot.OFFHAND);
        }
        if (ToolUtils.getHeldTool(entity, EquipmentSlot.MAINHAND) != null) {
            return ToolUtils.getHeldTool(entity, EquipmentSlot.MAINHAND);
        }
        return null;
    }

    public static int getHeadModifierLevel(LivingEntity entity, ModifierId modifierId) {
        ToolStack toolStack = ToolStack.from((ItemStack)entity.m_6844_(EquipmentSlot.HEAD));
        if (!toolStack.isBroken()) {
            return ModifierUtil.getModifierLevel((ItemStack)entity.m_6844_(EquipmentSlot.HEAD), (ModifierId)modifierId);
        }
        return 0;
    }

    public static int getChestModifierLevel(LivingEntity entity, ModifierId modifierId) {
        ToolStack toolStack = ToolStack.from((ItemStack)entity.m_6844_(EquipmentSlot.CHEST));
        if (!toolStack.isBroken()) {
            return ModifierUtil.getModifierLevel((ItemStack)entity.m_6844_(EquipmentSlot.CHEST), (ModifierId)modifierId);
        }
        return 0;
    }

    public static int getLegsModifierLevel(LivingEntity entity, ModifierId modifierId) {
        ToolStack toolStack = ToolStack.from((ItemStack)entity.m_6844_(EquipmentSlot.LEGS));
        if (!toolStack.isBroken()) {
            return ModifierUtil.getModifierLevel((ItemStack)entity.m_6844_(EquipmentSlot.LEGS), (ModifierId)modifierId);
        }
        return 0;
    }

    public static int getFeetModifierLevel(LivingEntity entity, ModifierId modifierId) {
        ToolStack toolStack = ToolStack.from((ItemStack)entity.m_6844_(EquipmentSlot.FEET));
        if (!toolStack.isBroken()) {
            return ModifierUtil.getModifierLevel((ItemStack)entity.m_6844_(EquipmentSlot.FEET), (ModifierId)modifierId);
        }
        return 0;
    }

    public static boolean hasModifierInAllArmor(LivingEntity entity, ModifierId modifierId) {
        return ToolUtils.getHeadModifierLevel(entity, modifierId) > 0 && ToolUtils.getChestModifierLevel(entity, modifierId) > 0 && ToolUtils.getLegsModifierLevel(entity, modifierId) > 0 && ToolUtils.getFeetModifierLevel(entity, modifierId) > 0;
    }

    public static int getSingleModifierArmorAllLevel(LivingEntity entity, ModifierId modifierId) {
        return ToolUtils.getHeadModifierLevel(entity, modifierId) + ToolUtils.getChestModifierLevel(entity, modifierId) + ToolUtils.getLegsModifierLevel(entity, modifierId) + ToolUtils.getFeetModifierLevel(entity, modifierId);
    }

    public static boolean isNotBrokenOrNull(IToolStackView tool) {
        return tool != null && !tool.isBroken();
    }

    public static boolean hasModifierIn(IToolStackView tool, Modifier modifier) {
        return tool.getModifierLevel(modifier) > 0;
    }

    public static boolean hasModifierIn(IToolStackView tool, ResourceLocation id) {
        return tool.getModifierLevel(new ModifierId(id)) > 0;
    }

    public static boolean hasMetaIn(ToolStack tool, String id) {
        Iterator iterator = tool.getMaterials().getList().iterator();
        if (iterator.hasNext()) {
            MaterialVariant material = (MaterialVariant)iterator.next();
            return material.get().getIdentifier().toString().equals(id);
        }
        return false;
    }

    public static class Curios {
        public static List<ItemStack> getStacks(LivingEntity entity) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            LazyOptional handler = CuriosApi.getCuriosHelper().getCuriosHandler(entity);
            if (handler.resolve().isEmpty()) {
                return list;
            }
            for (ICurioStacksHandler curios : ((ICuriosItemHandler)handler.resolve().get()).getCurios().values()) {
                for (int i = 0; i < curios.getSlots(); ++i) {
                    ItemStack stack = curios.getStacks().getStackInSlot(i);
                    if (stack.m_41619_() || !stack.m_204117_(TinkerTags.Items.MODIFIABLE)) continue;
                    list.add(stack);
                }
            }
            return list;
        }
    }
}

